package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.service.UserProfileService;
import gov.va.med.mhv.usermgmt.service.UserRegistrationService;

@Component
public class UserRegistrationServiceImpl implements UserRegistrationService {
	private static Logger log = LogManager.getLogger(UserRegistrationServiceImpl.class);

	@Autowired
	private UserProfileService userProfileService;
	
	@Override
	public UserProfileDTO registerUser(UserProfileDTO userProfile) throws MHVException {
		log.debug(" userName=" + userProfile.getUserName());
		log.debug(userProfile);
		
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();

		try {
			userProfile.setRestrictSIPAccess(false);
			userProfileService.registerUser(userProfile, response);

			// check for validation errors
			if (response.isFailure() ||(response.getInfoMessages() != null && !response.getInfoMessages().isEmpty())) {
				if (log.isDebugEnabled()) {
					log.debug(response);
					if (response.getValidationErrors() != null && !response.getValidationErrors().isEmpty()) {
						log.debug("Validation errors");
						for (Map.Entry<String, String> entry : response.getValidationErrors().entrySet()) {
						    String key = entry.getKey().toString();
						    String value = entry.getValue();
						    log.debug("key, " + key + " value " + value);
						}
					}
					if (response.getInfoMessages() != null && !response.getInfoMessages().isEmpty()) {
						log.debug("Info messages");
						for (Map.Entry<String, String> entry : response.getInfoMessages().entrySet()) {
						    String key = entry.getKey().toString();
						    String value = entry.getValue();
						    log.debug("key, " + key + " value " + value);
						}
					}
				}
				log.error(response.getFailureMessage());
				ObjectMapper mapper = new ObjectMapper();
				
				String userProfileString=null;
				if(userProfile != null){
				  userProfileString = mapper.writeValueAsString(userProfile);
				}
				
				throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage(),userProfileString);
			} else {
				response.setSuccess(true);
			}
			
			log.debug("saveUserRegistration is successful...");
		} catch (MHVException ex) {
			log.error(ex);
			throw ex;
		} catch (Exception e) {
System.out.println("******************************************** UserRegistrationServiceImpl registerUser - Exception Caught User Registration");			
e.printStackTrace();			
			String errorMessage = "Exception Caught User Registration";
			log.error(errorMessage, e);
			throw new MHVException(errorMessage, e);
		}
		return userProfile;
	}

}
